/**
 * MachForm
 * 
 * © 2007–2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */

//code for overloading the :contains selector to be case insensitive
jQuery.expr.pseudos.Contains = function(a, i, m) {
  return jQuery(a).text().toUpperCase()
      .indexOf(m[3].toUpperCase()) >= 0;
};
jQuery.expr.pseudos.contains = function(a, i, m) {
  return jQuery(a).text().toUpperCase()
      .indexOf(m[3].toUpperCase()) >= 0;
};

var selected_form_id = null; 
var tippy_form_id = null; //the selected form_id when the tippy tooltip shown

$(function(){
    
	/***************************************************************************************************************/	
	/* 1. Attach events to Form Title															   				   */
	/***************************************************************************************************************/
	
	//expand the form list when being clicked
	$(".middle_form_bar > h3").on('click',function(){
		
		var selected_form_li_id = $(this).parent().parent().attr('id');
	
		//show or hide all the options
		$("#" + selected_form_li_id + " .bottom_form_bar").slideToggle('fast');
		
		//once all options has been shown/hide, toggle the parent class
		$("#" + selected_form_li_id + " .bottom_form_bar").promise().done(function() {
			$("#" + selected_form_li_id).toggleClass('form_selected');
		});

	});
	
	
	/***************************************************************************************************************/	
	/* 3. Attach events to pagination buttons													   				   */
	/***************************************************************************************************************/
	
	//initialize pagination buttons once buttons exceed 20
	var max_pagination_buttons = 20;
	var has_pagination = false;

	if($("#mf_pagination > li").length > max_pagination_buttons){
		has_pagination = true;

		//upon first load, display the last buttons and the first (max_pagination_buttons - 1) buttons
		$("#mf_pagination > li").hide();
		$("#mf_pagination > li").slice(0,max_pagination_buttons - 1).show();

		//display the last button
		$("#mf_pagination > li:last-child").show();

		//add dot control before the last button
		$('<li class="pagedot pagedotlast">...</li>').insertBefore('#mf_pagination > li:last-child');

	}

	$("#mf_pagination > li:not('.pagedot')").on('click',function(){
		var display_list = $(this).data('liform_list');
		var slice_amount = ((max_pagination_buttons - 2) / 2) - 1;

		$("#mf_form_list > li").hide();
		$(display_list).show();
		
		$("#mf_pagination > li.current_page").removeClass('current_page');
		$(this).addClass('current_page');

		if(has_pagination){
			//get current position amongst visible buttons
			var clicked_button_position 		 = $("#mf_pagination > li:visible").index($(this)) + 1;
			var clicked_button_absolute_position = parseInt($(this).text());
			var last_button_position 	= $("#mf_pagination > li:visible").length;
			var last_pagedot_position 	= $("#mf_pagination > li:visible").index($("li.pagedotlast")) + 1;
			var first_pagedot_position 	= $("#mf_pagination > li:visible").index($("li.pagedotfirst")) + 1;
			var start_slice_position 	= 0;
			var end_slice_position		= 0;
			
			//re-arrange pagination buttons based on clicked button position
			if(clicked_button_position == last_button_position){
				//if position is the last button

				//hide all buttons first
				$("#mf_pagination > li").hide();

				//remove pagedots
				$("#mf_pagination > .pagedot").remove();

				//display the last (max_pagination_buttons - 1) button and the first button and pagedot
				$("#mf_pagination > li").slice(-(max_pagination_buttons-1)).show();

				//display the first button
				$("#mf_pagination > li:first-child").show();

				//add pagedot after the first button
				$('<li class="pagedot pagedotfirst">...</li>').insertAfter('#mf_pagination > li:first-child');
			}else if(clicked_button_position == 1){
				//if position is the first button
				
				//hide all buttons first
				$("#mf_pagination > li").hide();

				//remove pagedots
				$("#mf_pagination > .pagedot").remove();

				//display the first (max_pagination_buttons - 1) button and the last button and pagedot
				$("#mf_pagination > li").slice(0,max_pagination_buttons - 1).show();

				//display the last button
				$("#mf_pagination > li:last-child").show();

				//add pagedot before the last button
				$('<li class="pagedot pagedotlast">...</li>').insertBefore('#mf_pagination > li:last-child');
			}else if(clicked_button_position == (last_pagedot_position - 1) || clicked_button_position == (first_pagedot_position + 1)){
				//if position is the last button before dots or the first button after dots

				//hide all buttons first
				$("#mf_pagination > li").hide();

				//remove pagedots
				$("#mf_pagination > .pagedot").remove();

				//slice the buttons and put the clicked button on the middle
				start_slice_position = clicked_button_absolute_position - (slice_amount + 2);
				end_slice_position = (slice_amount * 2) + 1;
				
				if(start_slice_position < 0){
					start_slice_position = 0;
				}else{
					//add pagedot after the first button
					$('<li class="pagedot pagedotfirst">...</li>').insertAfter('#mf_pagination > li:first-child');
				}

				var last_button_absolute_position = parseInt($('#mf_pagination > li:last-child').text());
				if(start_slice_position + end_slice_position < last_button_absolute_position){
					//add pagedot before the last button
					$('<li class="pagedot pagedotlast">...</li>').insertBefore('#mf_pagination > li:last-child');
				}

				$("#mf_pagination > li:gt(" + start_slice_position + "):lt(" + end_slice_position + ")").show();

				//display the first & last button
				$("#mf_pagination > li:first-child,#mf_pagination > li:last-child").show();

			}
			
		}
	});
	
	
	/***************************************************************************************************************/	
	/* 4. Attach events to search input															   				   */
	/***************************************************************************************************************/
	
	//expand the search box
	$("#filter_form_input").on('focusin click',function(){
		
		if($("#filter_form_input").val() == 'find form...'){
			$("#filter_form_input").val('');
	
			if(screen.width >= 480){
				$("#mf_search_box,#filter_form_input").animate({'width': '+=165px'},{duration:200,queue:false});
			}
			
			$("#mf_search_box,#filter_form_input").promise().done(function() {
				$("#mf_search_title,#mf_search_tag").slideDown('medium');
				
				$("#mf_search_title,#mf_search_tag").promise().done(function(){
					$("#mf_search_box").addClass('search_focused');
					$("#mf_search_box,#filter_form_input").removeAttr('style');
				});
			});	
		}
		
		//shrink all opened forms
		$('.bottom_form_bar').hide();
		$(".form_selected").removeClass('form_selected');
		
	});
	
	//attach event to 'form title / form tags' tabs
	$("#mf_search_title").on('click',function(){
		$(this).addClass('mf_pane_selected');
		$("#mf_search_title a").html('&#8674; form title');
		
		$("#mf_search_tag a").html('form tags');
		$("#mf_search_tag").removeClass('mf_pane_selected');
		$("#filter_form_input").val('');
		
		//restore back the filter to the original condition
		reset_form_filter();
		
		$("#filter_form_input").trigger("focus");
		
		return false;
	});
	
	$("#mf_search_tag").on('click',function(){
		$(this).addClass('mf_pane_selected');
		$("#mf_search_tag a").html('&#8674; form tags')
		
		$("#mf_search_title a").html('form title');
		$("#mf_search_title").removeClass('mf_pane_selected');
		$("#filter_form_input").val('');
		
		//restore back the filter to the original condition
		reset_form_filter();
		
		$("#filter_form_input").trigger("focus");
		
		return false;
	});
	
	
	//filter the form when user type the search term
	$("#filter_form_input").on("keyup",function(){
		var search_term = $(this).val();
		var max_search_result = 10;
		
		
		if(search_term != ''){
			//first hide all form
			$("#mf_form_list > li").removeClass('result_set').hide();
			
			//hide pagination
			$("#mf_pagination").hide();
			
			if($("#mf_search_title").hasClass('mf_pane_selected')){ //search on form title
				var result_h3 = $("#mf_form_list h3:contains('"+ search_term + "')");
				
				result_h3.parent().parent().show().addClass('result_set');
				result_h3.unhighlight();
				result_h3.highlight(search_term);
				
				$("#filtered_result_box span.highlight").text(search_term);
				$("#filtered_result_box").fadeIn();
				
				$("#filtered_result_total").text('Found ' + result_h3.length + ' forms');
				
				if(result_h3.length == 0){
					$("#filtered_result_none").fadeIn();
				}else{
					$("#filtered_result_none").hide();
				}
				
				//if the result set exceed the limit, hide the rest and display "show more" button
				if(result_h3.length > max_search_result){
					$("#result_set_show_more").show();
					
					$(".result_set:gt("+ (max_search_result - 1) + ")").hide();
				}else{
					$("#result_set_show_more").hide();
				}
			}else{ //search on form tags
				var result_li = $("ul.form_tag_list li:contains('"+ search_term + "')");
				
				result_li.parent().parent().parent().parent().parent().show().addClass('result_set');
				result_li.unhighlight();
				result_li.highlight(search_term);
				
				$("#filtered_result_box span.highlight").text(search_term);
				$("#filtered_result_box").fadeIn();
				
				$("#filtered_result_total").text('Found ' + result_li.length + ' forms');
				
				if(result_li.length == 0){
					$("#filtered_result_none").fadeIn();
				}else{
					$("#filtered_result_none").hide();
				}
				
				//if the result set exceed the limit, hide the rest and display "show more" button
				if(result_li.length > max_search_result){
					$("#result_set_show_more").show();
					
					$(".result_set:gt("+ (max_search_result - 1) + ")").hide();
				}else{
					$("#result_set_show_more").hide();
				}
			}
			
		}else{
			//if the filter keyword is empty, restore back to the original condition
			reset_form_filter();
			
		}
		
	});
	
	$("#mf_filter_reset").on('click',function(){
		reset_form_filter();

		$("#mf_search_box").removeClass('search_focused');
		$("#mf_search_title,#mf_search_tag").hide();
		
		$("#filter_form_input").val('find form...');
		
		return false;
	});
	
	//attach event handler to "show more result" on filter result
	$("#result_set_show_more > a").on('click',function(){
		var show_more_increment = 20; //the number of more results being displayed each time the button being clicked
		
		var last_result_index = $(".result_set:visible").last().index('.result_set');
		var next_start_index = last_result_index + 1;
		var next_end_index   = next_start_index + show_more_increment;
		
		$(".result_set").slice(next_start_index,next_end_index).fadeIn();
		
		if(next_end_index >= $(".result_set").length){
			$("#result_set_show_more").hide();
		}
		
		return false;
	});
	
	//initialize autoComplete search box
	if(typeof autocomplete_config !== "undefined"){
		const autoCompleteJS = new autoComplete(autocomplete_config);
	
		//attach event handler when selection to autocomplete list was made
		document.querySelector("#mf_search_title_autocomplete").addEventListener("selection", function (event) {
			// "event.detail" carries the autoComplete.js "feedback" object
			var selected_title = event.detail.selection.value;
			var result = selected_title.match(/{#.*?#}/g);
			var selected_form_id = result[0].replaceAll('{#','').replaceAll('#}','');
			
			$("#mf_form_list .form_visible").removeClass('form_visible');
			$("#mf_form_list .form_selected").removeClass('form_selected');
			$("#mf_form_list > li").hide();
			$("#mf_pagination").hide();

			$("#liform_" + selected_form_id).show().addClass("form_visible").addClass("form_selected");
			$("#mf_filter_autocomplete_reset_div").show();
		});
	}

	$("#mf_filter_autocomplete_reset").on('click',function(){
		$("#mf_form_list > li").hide();
		$("#mf_pagination").show();
		
		if($("#mf_pagination > li.current_page").length > 0){
			$($("#mf_pagination > li.current_page").data('liform_list')).show();
		}else{
			$("#mf_form_list > li").show();
		}

		$("#mf_filter_autocomplete_reset_div").hide();
		$("#mf_search_title_autocomplete").val('').trigger("focus");

		return false;
	});
	/***************************************************************************************************************/	
	/* 5. Dialog box to enter a tag name														   				   */
	/***************************************************************************************************************/
	
	//attach event to add form tag
	$("ul.form_tag_list a.addtag").on('click',function(){
		var list_tags = $('#mf_form_list').data('available_tags');
		var temp = $(this).attr('id').split('_');
		var form_id = parseInt(temp[1]);
		var csrf_token = $("#content").data("csrftoken");

		Swal.fire({
			title: 'Add Tags',
			html: '<p style="font-size: 90%;font-weight: normal;margin-bottom: 15px">Tag name is optional. Use it when you have many forms, to group them into categories. </p><input type="text" id="input-tagnames" class="swal2-input" placeholder="tag1, tag2, tag3" type="search" dir="ltr" spellcheck=false autocorrect="off" autocomplete="off" autocapitalize="off" tabindex="1">',
			width: '40%',
			customClass: {
				htmlContainer: 'swal2-html-container'
			},
			showCancelButton: true,
			confirmButtonText: 'Add Tags',
			showLoaderOnConfirm: true,
			willOpen: () => {
				$('.swal2-html-container').height(75);
			},
			didOpen: () => {
				document.querySelector('#input-tagnames').focus();
				const inputtagnames = document.querySelector('#input-tagnames');
				
				//attach event handler to the input button, when the user hit the enter key, save the tag
				inputtagnames.addEventListener('keydown', (event) => {
					if (event.key === 'Enter') {
						tagvalue = $('#input-tagnames').val();
						return axios.post('save_tags.php', {
							action: 'add',
							form_id: form_id,
							tags: tagvalue,
							csrf_token: csrf_token
						})
						.then(function (response) {
							if(response.data.status == 'ok'){						
								list_tags = list_tags.filter(item => item !== tagvalue);
								list_tags.push(tagvalue);
								$('#mf_form_list').data('available_tags',list_tags);

								$("#liform_" + response.data.form_id + " li.form_tag_list_icon").siblings().remove();
								$("#liform_" + response.data.form_id + " ul.form_tag_list").append(response.data.tags_markup);

								Swal.close();

								return response;
							}else{
								Swal.showValidationMessage('Error: Unable to process. Please try again later.');
							}
						})
						.catch(function (error) {
							Swal.showValidationMessage("Error: " + error);
						});
					}
				});
			},
			preConfirm: (tagnames) => {
				tagvalue = $('#input-tagnames').val();
				return axios.post('save_tags.php', {
					action: 'add',
					form_id: form_id,
					tags: tagvalue,
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){						
						list_tags = list_tags.filter(item => item !== tagvalue);
						list_tags.push(tagvalue);
						$('#mf_form_list').data('available_tags',list_tags);

						return response;
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				});
			},
			allowOutsideClick: () => !Swal.isLoading()
		}).then((result) => {
			if(result.isConfirmed) {
				$("#liform_" + result.value.data.form_id + " li.form_tag_list_icon").siblings().remove();
				$("#liform_" + result.value.data.form_id + " ul.form_tag_list").append(result.value.data.tags_markup);
			}
		});

		const autoCompleteJS = new autoComplete({
            selector: "#input-tagnames",
            placeHolder: "tag1, tag2, tag3",
            data: {
                src: list_tags,
                cache: true,
            },			
            resultsList: {
                element: (list, data) => {
					if (data.results.length > 0) {
						$('.swal2-html-container').height(160);
					}
                },
                noResults: true,
				maxResults: 2,
            },
            resultItem: {
                highlight: true
            },
            events: {
                input: {
                    selection: (event) => {
                        const selection = event.detail.selection.value;						
                        autoCompleteJS.input.value = selection;
                    }
                }
            }
        });

		document.querySelector("#input-tagnames").addEventListener("close", function (event) {
			$('.swal2-html-container').height(75);
		});

		
		return false;
	});

	//attach event to 'import form' button
	$("#button_import_form").on('click',function(){
		
		Swal.fire({
			title: 'Import form template',
			html: '<input id="mf_form_import_file" class="element file" type="file" />',
			footer: 'Upload form file with *.json extension only.',
			width: '25%',
			customClass: {
				htmlContainer: 'swal2-html-container-bold',
				footer: 'swal2-footer-info'
			},
			showCancelButton: false,
			showConfirmButton: false,
			didOpen: () => {
				init_import_file_uploader();
			}
		});

		return false;
	});
	
	//delegate onclick event to delete tag link
	$('#mf_form_list').on('click', 'a.removetag', function(e) {
		
		var selected_list = $(this).parent().parent().closest('li').attr('id');
		
		var temp = selected_list.split('_');
		var form_id = parseInt(temp[1]);
		var csrf_token = $("#content").data("csrftoken");
		
		var selected_tagname = $(this).parent().text();
		var parent_list = $(this).parent();
		
		//do the ajax call to delete the tag
		axios.post('save_tags.php', {
			action: 'delete',
			form_id: form_id,
			tags: selected_tagname,
			csrf_token: csrf_token
		})
		.then(function (response) {
			if(response.data.status == 'ok'){
				parent_list.fadeOut(function(){$(this).remove()});
			}else{
				Swal.fire({
					toast: true,
					text: `Error: Unable to process.`,
					icon: 'error'
				});
			}
		})
		.catch(function (error) {
			Swal.fire({
				toast: true,
				text: `Error: ${error}`,
				icon: 'error'
			});
		});
		
		
		return false;
    });
	
	
	/***************************************************************************************************************/	
	/* 6. Highlight particular form if the variable exist														   */
	/***************************************************************************************************************/
	
	//this is being used to highlight a newly created form, as a result of a duplicate action
	if(selected_form_id_highlight > 0){
		$("#liform_" + selected_form_id_highlight + " div.middle_form_bar").hide().fadeIn();
	}
	
	/***************************************************************************************************************/	
	/* 8. Attach events to 'Theme' link														   				   */
	/***************************************************************************************************************/
	
	//open the dialog when the change theme link clicked
	$(".mf_link_theme").on('click',function(){
		
		var parent_li = $(this).parent().parent().parent();
		var temp = parent_li.attr('id').split('_');
		var form_id = parseInt(temp[1]);
		var csrf_token = $("#content").data("csrftoken");
				
		Swal.fire({
			title: 'Select a theme',
			html: $("#dialog-change-theme").html(),
			width: '25%',
			customClass: {
				footer: 'swal2-footer-info',
				title: 'swal2-title-warning'
			},
			didOpen: () => {
				//set the value of the theme dropdown to the current active theme for this form
				$("#dialog-change-theme-input").val(parent_li.data('theme_id'));

				//if the user select "create new theme" on the theme selection dropdown
				$('#dialog-change-theme-input').on('change', function() {
					if($(this).val() == "new"){
						//redirect to theme editor
						window.location.replace('edit_theme.php');
					}
				});
			},
			confirmButtonText: 'Save Changes',
			cancelButtonText: 'Cancel',
			showCancelButton: true,
			showConfirmButton: true,
			showLoaderOnConfirm: true,
			allowOutsideClick: () => !Swal.isLoading(),
			preConfirm: (tagnames) => {
				return axios.post('change_theme.php', {
					form_id: form_id,
					theme_id: $("#dialog-change-theme-input").val(),
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						//update the dom data
						parent_li.data('theme_id',$("#dialog-change-theme-input").val());	
						return response;
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				});
			}
		});
		
		return false;
	});
	

	/***************************************************************************************************************/	
	/* 9. Attach events to dropui buttons														   				   */
	/***************************************************************************************************************/

	$(".manage_forms a.dropui-tab").on('click',function(){
		if($(this).attr("id") == 'dropui-sort-form'){
			$("#dropui-filter-form").parent().removeClass("hovered");
			$("#dropui-filter-form").next().hide();
		}else if($(this).attr("id") == 'dropui-filter-form'){
			$("#dropui-sort-form").parent().removeClass("hovered");
			$("#dropui-sort-form").next().hide();
		}

		if($(this).parent().hasClass("hovered")){
			$(this).parent().removeClass('hovered');
			$(this).next().hide(); //hide the properties container
		}else{
			$(this).parent().addClass('hovered');
			$(this).next().show(); //display the properties container
		}	
	});

	/***************************************************************************************************************/	
	/* 11. Form Filters																			   				   */
	/***************************************************************************************************************/
		
	//attach event to the 'filter list toggle' link
	$("#mf_filters_toggle_button").on('click',function(){

		$('.content_body_sidebar').toggleClass('filter_list_expand_sidebar');
		$('.content_body_main').toggleClass('filter_list_expand_main');

		return false;
	});

	/***************************************************************************************************************/	
	/* 12. Form Import																			   				   */
	/***************************************************************************************************************/

	//initialize file uploader for export/import tool
	function init_import_file_uploader(){
		$('#mf_form_import_file').uploadifive({
			'uploadScript'     	: 'import_form_uploader.php',
			'buttonText'        : 'Select File',
			'removeCompleted' 	: true,
			'formData'         	 : {
									'session_id': $(".manage_forms").data("session_id")
								},
			'auto'        : true,
			'multi'       : false,
			'onUploadError' : function(file, errorCode, errorMsg, errorString) {
									alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
							},
			'onUploadComplete' : function(file, response) {
				var is_valid_response = false;
				try{
					var response_json = JSON.parse(response);
					is_valid_response = true;
				}catch(e){
					is_valid_response = false;
					alert(response);
				}
				
				if(is_valid_response == true && response_json.status == "ok"){
					var uploaded_form_file = response_json.file_name;
					var csrf_token = $("#content").data("csrftoken");

					//do ajax call to parse the file
					axios.post('import_form_parser.php', {
						file_name: uploaded_form_file,
						csrf_token: csrf_token
					})
					.then(function (response) {
						if(response.data.status == 'ok'){
							Swal.fire({
								icon: 'success',
								title: 'Success! Import completed',
								html: 'The following form has been imported:<br/>' + 
									  '<a id="form-imported-link" target="_blank" style="color: #529214;font-size: 120%;border: none;background: none;float: none" href="#">x</a>',
								width: '30%',
								customClass: {
									title: 'swal2-title-success',
									htmlContainer: 'swal2-html-container-bold'
								},
								didOpen: () => {
									$("#form-imported-link").text(response.data.new_form_name);
									$("#form-imported-link").attr("href","view.php?id=" + response.data.new_form_id);
								},
								confirmButtonText: 'Edit Form',
								cancelButtonText: 'Done',
								showCancelButton: true,
								showConfirmButton: true,
								allowOutsideClick: false
							}).then((result) => {
								if(result.isConfirmed) {
									//redirect to edit form link
									window.location.replace('edit_form.php?id=' + response.data.new_form_id);
								}else{
									window.location.replace('manage_forms.php?id=' + response.data.new_form_id);
								}
							});
						}else{
							//display error dialog
							Swal.fire({
								toast: true,
								html: `Error: ${response.data.message}`,
								icon: 'error',
								width: '30%',
							});
						}
					})
					.catch(function (error) {
						Swal.fire({
							toast: true,
							text: `Error: ${error}`,
							icon: 'error'
						});
					});
				}else{
					alert('Error uploading file. Please try again.');
				}  
			} 

		});

	}
	
	tippy('.form_actions_toggle', {
		content: function(element){
			return document.getElementById('action_toggle_content_' + element.dataset.formid).innerHTML;
		},
		placement: 'bottom',
		onShown: function(instance){
			tippy_form_id = instance.reference.dataset.formid;

			//bind event handlers to all links within the tooltip
			bind_delete_form_event();
			bind_disable_form_event();
			bind_duplicate_form_event();
			bind_export_form_event();
		},
		trigger: 'click',
		interactive: true,
		ignoreAttributes: true,
		arrow: true
	});

	tippy('#mf_sort_pane_button', {
		content: function(element){
			return document.getElementById('mf_sort_pane_content').innerHTML;
		},
		placement: 'bottom',
		onShown: function(instance){
			
		},
		trigger: 'click',
		interactive: true,
		ignoreAttributes: true,
		arrow: true
	});

	tippy('#mf_filters_toggle2_button', {
		content: function(element){
			return document.getElementById('mf_filters_toggle2_content').innerHTML;
		},
		placement: 'bottom',
		onShown: function(instance){
			
		},
		trigger: 'click',
		interactive: true,
		ignoreAttributes: true,
		arrow: true
	});
});

/** Functions **/

//clear the form filter
function reset_form_filter(){
	$("#mf_form_list > li").hide();
	$("#mf_pagination").show();
	
	if($("#mf_pagination > li.current_page").length > 0){
		$($("#mf_pagination > li.current_page").data('liform_list')).show();
	}else{
		$("#mf_form_list > li").show();
	}

	$("#mf_form_list h3").unhighlight();
	$("ul.form_tag_list li").unhighlight();
	
	$("#filtered_result_box").fadeOut();
	$("#filtered_result_none").hide();
	
	$("#result_set_show_more").hide();
}

//attach event to the 'Delete' link on the tooltip
function bind_delete_form_event(){
		
		//open the dialog when the delete link clicked
		$(".mf_link_delete a").on('click',function(){
			var form_id 	= tippy_form_id;
			var parent_li 	= $("#liform_" + form_id);
			var form_name 	= parent_li.find('h3').text();
			var csrf_token 	= $("#content").data("csrftoken");

			//hide the tooltip
			var tippy_instance = $('.form_actions_toggle.tippy-active')[0]._tippy;
			tippy_instance.hide();

			Swal.fire({
				title: 'Are you sure you want to delete this form?',
				html: 'All data and files collected by <span id="confirm_form_delete_name">' + form_name + '</span> will also be deleted.',
				footer: 'This action cannot be undone.',
				icon: 'warning',
				width: '40%',
				customClass: {
					htmlContainer: 'swal2-html-container-bold swal2-html-container-padding-bottom',
					footer: 'swal2-footer-warning',
					title: 'swal2-title-warning'
				},
				showCancelButton: true,
				confirmButtonText: 'Yes. Delete this form.',
				showLoaderOnConfirm: true,
				preConfirm: () => {
					return axios.post('delete_form.php', {
						form_id: form_id,
						csrf_token: csrf_token
					})
					.then(function (response) {
						if(response.data.status == 'ok'){
							return response;
						}else{
							Swal.showValidationMessage('Error: Unable to process. Please try again later.');
						}
					})
					.catch(function (error) {
						Swal.showValidationMessage("Error: " + error);
					})
				},
				allowOutsideClick: () => !Swal.isLoading()
			}).then((result) => {
				if(result.isConfirmed) {
					//redirect to form manager
					window.location.replace('manage_forms.php');
				}
			});

			//we need to unbind the event, otherwise it will add up each time the tooltip displayed
			$(".mf_link_delete a").off("click");
			
			return false;
		});
}

//attach event to the 'Delete' link on the tooltip
function bind_disable_form_event(){
	//enable or disable the form
	$(".mf_link_disable a").on('click',function(){
			var current_form_id = tippy_form_id;
			var current_action = '';
			var csrf_token = $("#content").data("csrftoken");

			//hide the tooltip
			var tippy_instance = $('.form_actions_toggle.tippy-active')[0]._tippy;
			
			
			current_action = $(this).text().trim().toLowerCase()

			if(current_action == 'disable'){
				tippy_instance.hide();

				selected_form_id = current_form_id;
				
				Swal.fire({
					title: 'Are you sure you want to disable this form?',
					html: 'Your form will be closed and the message below will be displayed:',
					width: '40%',
					input: 'textarea',
					icon: 'warning',
					footer: "Your form data will remain intact even when the form is disabled",
					inputPlaceholder: 'This form is currently inactive.',
					customClass: {
						htmlContainer: 'swal2-html-container-bold',
						footer: 'swal2-footer-info',
						title: 'swal2-title-warning',
						input: 'input-disable-form'
					},
					didOpen: () => {
						var current_message = $("#liform_" + selected_form_id).data("form_disabled_message");
			
						if(current_message == "" || current_message == null){
							current_message = 'This form is currently inactive.';
						}
						
						$(".input-disable-form").val(current_message);
					},
					showCancelButton: true,
					confirmButtonText: 'Disable this form',
					showLoaderOnConfirm: true,
					preConfirm: (message) => {
						
						return axios.post('toggle_form.php', {
							action: 'disable',
							form_id: selected_form_id,
							disabled_message: message,
							csrf_token: csrf_token
						})
						.then(function (response) {
							if(response.data.status == 'ok'){
								return response;
							}else{
								Swal.showValidationMessage('Error: Unable to process. Please try again later.');
							}
						})
						.catch(function (error) {
							Swal.showValidationMessage("Error: " + error);
						});
					},
					allowOutsideClick: () => !Swal.isLoading()
				}).then((result) => {
					if(result.isConfirmed) {
						//update the dom data
						$("#liform_" + selected_form_id).data("form_disabled_message",$(".input-disable-form").val());

						if(result.value.data.action == 'disable'){
							$("#liform_" + result.value.data.form_id).addClass('form_inactive');
							$("#action_toggle_content_" + result.value.data.form_id + " .mf_link_disable a").html('<span class="icon-play-circle"></span> Enable');
							$("#form_action_" + result.value.data.form_id)[0]._tippy.setContent($("#action_toggle_content_" + result.value.data.form_id).html());
						}
					}
				});

			}else if(current_action == 'enable'){
				//change the 'Delete' text
				$(this).text('Processing...');
				
				//do the ajax call to enable or disable the form
				axios.post('toggle_form.php', {
					form_id: current_form_id,
					action: current_action,
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						if(response.data.action == 'disable'){
							$("#liform_" + response.data.form_id).addClass('form_inactive');
							$("#action_toggle_content_" + response.data.form_id + " .mf_link_disable a").html('<span class="icon-play-circle"></span> Enable');
							
						}else{
							$("#liform_" + response.data.form_id).removeClass('form_inactive');
							$("#action_toggle_content_" + response.data.form_id + " .mf_link_disable a").html('<span class="icon-pause-circle"></span> Disable');
						   
						}
						$("#form_action_" + response.data.form_id)[0]._tippy.setContent($("#action_toggle_content_" + response.data.form_id).html());
					}else{
						Swal.fire({
							toast: true,
							text: `Error: Unable to process.`,
							icon: 'error'
						});
					}
				})
				.catch(function (error) {
					Swal.fire({
						toast: true,
						text: `Error: ${error}`,
						icon: 'error'
					});
				});
				
				tippy_instance.hide();
				//end of ajax call
			}

			//we need to unbind the event, otherwise it will add up each time the tooltip displayed
			$(".mf_link_disable a").off("click");

			return false;
	});
}

//attach event to the 'Duplicate' link on the tooltip
function bind_duplicate_form_event(){
	$(".mf_link_duplicate a").on('click',function(){
		var current_form_id = tippy_form_id;
		var tippy_instance = $('.form_actions_toggle.tippy-active')[0]._tippy;
		var self_link = $(this);
		var csrf_token = $("#content").data("csrftoken");

		if($(this).text() == 'Duplicating...'){
			//we need to unbind the event, otherwise it will add up each time the tooltip displayed
			$(".mf_link_disable a").off("click");

			return false; //prevent the user from clicking multiple times
		}
		
		//change the 'Duplicate' text
		$(this).text('Duplicating...');
			
			
		//do the ajax call to duplicate the form
		axios.post('duplicate_form.php', {
			form_id: current_form_id,
			csrf_token: csrf_token
		})
		.then(function (response) {
				if(response.data.status == 'ok'){
					window.location.replace('manage_forms.php?id=' + response.data.form_id + '&hl=true');
				}else{
					self_link.html('<span class="icon-copy1"></span> Duplicate');
					Swal.fire({
						width: '30%',
						position: 'center',
						icon: 'error',
						title: 'Error. Unable to complete the task.',
						html: response.data,
						showConfirmButton: false,
						showCancelButton: true,
						cancelButtonText: 'Close',
						allowOutsideClick: true
					});
				}
		})
		.catch(function (error) {
				self_link.html('<span class="icon-copy1"></span> Duplicate');
				Swal.fire({
					width: '30%',
					position: 'center',
					icon: 'error',
					title: 'Error. Unable to complete the task.',
					html: error,
					showConfirmButton: false,
					showCancelButton: true,
					cancelButtonText: 'Close',
					allowOutsideClick: true
				});
		});

		//we need to unbind the event, otherwise it will add up each time the tooltip displayed
		$(".mf_link_disable a").off("click");

		return false;
	});
}

//attach event to 'export form' link on the tooltip
function bind_export_form_event(){
	//attach event to 'export form' button
	$(".mf_link_export a").on('click',function(){
		var selected_form_id = tippy_form_id;
		var tippy_instance = $('.form_actions_toggle.tippy-active')[0]._tippy;
		var csrf_token = $("#content").data("csrftoken");

		//we need to unbind the event, otherwise it will add up each time the tooltip displayed
		$(".mf_link_disable a").off("click");
		tippy_instance.hide();

		window.location.href = 'export_form.php?form_id=' + selected_form_id + '&csrf_token=' + csrf_token;

		return false;
	});
}

//pin/unpin smart folders sidebar
function toggle_pin_folders(){
	var pin_folder_status = 0;

	if($("#pin_folders").hasClass('pinned')){
		$("#pin_folders").removeClass('pinned');
		pin_folder_status = 0;
	}else{
		$("#pin_folders").addClass('pinned');
		pin_folder_status = 1;
	}

	//do the ajax call to toggle folder			
	axios.post('toggle_folder.php', {
		pin_folder: pin_folder_status
	})
	.then(function (response) {
		if(response.data.status == 'ok'){
			 //do nothing on success
		}else{
			Swal.fire({
				width: '30%',
				position: 'center',
				icon: 'error',
				title: 'Error. Unable to complete the task.',
				html: response.data,
				showConfirmButton: false,
				showCancelButton: true,
				cancelButtonText: 'Close',
				allowOutsideClick: true
			});
		}
	})
	.catch(function (error) {
		Swal.fire({
			width: '30%',
			position: 'center',
			icon: 'error',
			title: 'Error. Unable to complete the task.',
			html: error,
			showConfirmButton: false,
			showCancelButton: true,
			cancelButtonText: 'Close',
			allowOutsideClick: true
		});
	});
}